# Wargroove 2 (Steam, Windows, Linux)

## Where is the options page?

The [player options page for this game](../player-options) contains all the options you need to configure and export a
config file.

## What does randomization do to this game?

This randomizer shuffles units, map events, factions and boosts. It features a custom, non-linear campaign with 4 
final levels and 4 branching paths. The player cannot beat the final levels without specific items scattered throughout 
the branching paths. Certain levels on these paths may require specific units or items in order to progress.
Where levels appear in the campaign is randomized.

## What items and locations get shuffled?

1. Every buildable unit in the game (except for soldiers and dogs, which are free).
2. Commanders available to certain factions. If the player acquires the Floran Commanders, they can select any commander
from that faction.
3. Income, Groove and Commander Defense boosts that provide the player with extra income, extra commander groove 
or extra commander defense.
4. Special map events like the Bridges Event or the Walls Event, which perform special actions in certain levels.
5. 28 levels are shuffled into 4 branching paths. One of 4 starting levels will be at the beginning of each path.
One of 4 final levels will be at the ending of each path.

## Which items can be in another player's world?

Any of the above items can be in another player's world.

## How does Death Link work in Wargroove 2?

A player will send a death link if they are defeated after turn 1 and on an AI's turn.
Certain side goals can be reached without the ability to complete the level. Resigning to exit after completing a side
goal is standard practice. When the player receives a death link from another player, they will be eliminated when the 
next move is made.

## When the player receives an item, what happens?

When the player receives an item, a message will appear in Wargroove 2 with the item name and sender name, once an 
action is taken in game.

## What is the goal of this game when randomized?

The goal is to beat 1-4 final levels ending with the name "Finale" by finding the "Final North", "Final East", 
"Final South" or "Final West" items depending on which Finale the player is playing.
All final levels require the "Final Center". The "Northern Finale" for example, requires "Final North" and 
"Final Center" but the "Western Finale" requires "Final West" and "Final Center".

## Contributing levels to the randomizer

Anybody can contribute levels to the Wargroove 2 randomizer.
A contributor's guide can be found 
[here](https://docs.google.com/documen/d/1ovGGTKYJsJcLH4kLZ2k2FQes82sQ96C35gF6j_akCf4/edit?usp=sharing).

Current Contributors are:
- Fly Hyping (AKA Fly Sniper, for levels and code)
- Magnemania (Levels)
- Akblabla (Custom assets)
  - Sabah (Custom commander)

## Unique Local Commands

The following commands are only available when using the Wargroove2Client to play with MultiworldGG.

- `/resync` Manually trigger a resync.
- `/commander` Set the current commander to the given commander.
- `/deathlink` Toggle deathlink between On and Off.
- `/sacrifice_summon` Toggle sacrificing and summoning units between On and Off.
